<?php
ob_start();
session_start();
?>

<?
error_reporting(E_ALL);
ini_set("display_errors", 1);
?>

<html>

<head>
  <meta charset="UTF-8" />
  <title>Formulário de Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" type="text/css" href="login.css" />
  <style>
    .form-signin {
      max-width: 330px;
      padding: 15px;
      margin: 0 auto;
      color: #017572;
    }

    .form-signin .form-signin-heading,
    .form-signin .checkbox {
      margin-bottom: 10px;
    }

    .form-signin .checkbox {
      font-weight: normal;
    }
  </style>
</head>

<body>
  <div class="container">
    <div class="content">

      <div class="container form-signin">
        <?php
        $msg = '';
        if (
          isset($_POST['login']) && !empty($_POST['username'])
          && !empty($_POST['password'])
        ) {
          $url = "https://webapp.utfpr.edu.br/portalAluno/ws/auth";
          //Inicializando
          $curl = curl_init($url);
          curl_setopt($curl, CURLOPT_URL, $url);
          //Defina a opção CURLOPT_POST como verdadeiro para a solicitação POST
          curl_setopt($curl, CURLOPT_POST, true);
          curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($curl, CURLOPT_FAILONERROR, true);
          // Definir cabeçalhos personalizados para o headers da UTFPR Auth
          $headers = array(
            'Content-Type: application/json',
            'Accept: */*',
            'Connection: Keep-Alive'
          );
          curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
          //Defina os dados da solicitação como JSON usando a função json_encode
          $body = array(
            'username' => $_POST['username'],
            'password' => $_POST['password']
          );
          $data = json_encode($body);
          curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
          //for debug only!
          curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
          curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
          curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
          curl_setopt($curl, CURLOPT_DNS_USE_GLOBAL_CACHE, false);
          curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 2);
          //Execute a solicitação cURL com todas as configurações anteriores
          $resp = curl_exec($curl);
          if (curl_errno($curl))
            echo 'Curl error: ' . curl_error($curl);
          curl_close($curl);
          $obj = json_decode($resp);
          $headerequery = 'Location: bemvindo.php?' . $obj->{'token'};
          if ($obj->{'ativo'}) {
            header($headerequery);
            $msg = 'Sucesso';
            ob_end_flush();
            die();
          } else {
            $msg = 'Nome de usuário ou senha errada';
          }
        }
        ?>
      </div>

      <div id="login">

        <form method="post" role="form" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
          <div style="text-align: center">
            <div style="margin: 20px 0;">
              <img width="120px" src="./imgs/logo-utf-mais-prod.svg">
            </div>
          </div>
          <h1>Autenticação</h1>
          <div style="margin: 10px 0;" aria-live="polite" class="ui-message ui-widget ui-corner-all ui-message-info ng-star-inserted">
            <span style="font-size: 2em; padding: 0 0.1em;" class="ui-message-icon pi pi-info-circle">
            </span>
            <span class="ui-message-text">Acesse utilizando suas credenciais dos Sistemas Corporativos.<br>Exemplo: <b>joaosilva</b> (servidor) ou <b>a1234567</b> (aluno)</span>
          </div>
          <p>
            <label for="username">Usuário</label>
            <input name="username" required="required" type="text" placeholder="Usuário" />
          </p>

          <p>
            <label for="password">Senha</label>
            <input name="password" required="required" type="password" placeholder="Senha" />
          </p>
          <h5 style="color:red;" class="form-signin-heading"><?php echo $msg; ?></h4>
            <p>
              <input name="login" type="submit" value="Login" />
            </p>

            <p class="link">
              Esqueceu a senha?
              <a href="https://sistemas2.utfpr.edu.br/dpls/sistema/aluno00/mprecuperasenhaaluno.inicio">Recupere aqui</a>
            </p>
        </form>
      </div>
    </div>
  </div>
</body>

</html>